function [binary_prod_t, config_binary_t, full_prod_t, config_full_t]=...
    convert_config(t, oem_t, prod_id_drop, model_id_drop, ...
    brandeffect_t, p0_t, w0_t, q0_t, carrier_t, carrier_id_t, ...
    oem_id_t, model_id_t, product_id_t, meanutility_t0, mc_mean_t, x_rand, ...
    fc_sim_inMkt, fc_sim_potential, use_potential_prod, new_dropped_prod_list,...
    new_prod_list, shocksmln_demand, shocksmln_mc, ind_t, prod_id_add, ind_id_t, ...
    prod_id_add_dropped, new_potential_prod_list, n_top_gap, n_carrier, n_oem, id_fixed_t)

% convert products into cells
binary_prod_t = cell(n_oem, 1);
config_binary_t = cell(n_oem, 1);

full_prod_t = cell(n_oem, 1);
config_full_t = cell(n_oem, 1);

for no = 1 : n_oem
    if any(oem_t(:, no))
        % in market products
        id_fc_drop = model_id_drop{t, no};
        NP_ind = setdiff(id_fc_drop, id_fixed_t);
        
        NP = length(NP_ind);
        
        if length(unique(NP_ind))<NP; error('duplicated id'); end
        
        if NP>0
            binary_prod_no = cell(NP, 1);
            
            config_binary_no = ones(NP, 1);
                            
            for np = 1 : NP
                ind_np = ind_id_t==NP_ind(np);
                new_prod_j.brandeffect = brandeffect_t(ind_np);
                new_prod_j.p0 = p0_t(ind_np);
                new_prod_j.w0 = w0_t(ind_np);
                new_prod_j.q0 = q0_t(ind_np);
                new_prod_j.oem = oem_t(ind_np,:);
                new_prod_j.carrier = carrier_t(ind_np,:);
                new_prod_j.carrier_id = carrier_id_t(ind_np);
                new_prod_j.oem_id = oem_id_t(ind_np);
                new_prod_j.model_id = model_id_t(ind_np);
                new_prod_j.prod_id = product_id_t(ind_np);
                
                new_prod_j.mean_u = meanutility_t0(ind_np, :);
                new_prod_j.mean_mc = mc_mean_t(ind_np, :);    
                            
                if ~isempty(x_rand)
                    new_prod_j.x_rand = x_rand(ind_np, :);
                else
                    new_prod_j.x_rand = [];
                end

                new_prod_j.fc = fc_sim_inMkt{t, no}(id_fc_drop==NP_ind(np), :);
                binary_prod_no{np} = new_prod_j;
            end
        else
            binary_prod_no = [];
            config_binary_no = [];
        end
        
        % dropped products
        NP_dropped = length(new_dropped_prod_list{t, no});
        
        if use_potential_prod && length(prod_id_add_dropped{t, no})~=NP_dropped
            error('product type mismatch');
        end
        
        if NP_dropped>0
            binary_prod_dropped = new_prod_list{t, no}(1:NP_dropped,:);
            
            for npd = 1 : NP_dropped
                new_prod_j = binary_prod_dropped{npd};
                new_prod_j.mean_u = ...
                    new_prod_j.mean_u + shocksmln_demand(length(ind_t)+1, :);
                new_prod_j.mean_mc = ...
                    new_prod_j.mean_mc + shocksmln_mc(length(ind_t)+1, :);
                new_prod_j.fc = fc_sim_potential{t, no}(npd, :);
                binary_prod_dropped{npd} = new_prod_j;
            end
            
            
            config_binary_dropped = zeros(NP_dropped, 1);
            
        else
            binary_prod_dropped = [];
            config_binary_dropped = [];
        end
        
        binary_prod_no = [binary_prod_no; binary_prod_dropped];
        config_binary_no = [config_binary_no; config_binary_dropped];
        
        binary_prod_t{no} = binary_prod_no;
        config_binary_t{no} = config_binary_no;
        
        
        if use_potential_prod            
            full_prod_t{no} = new_potential_prod_list{t, no};
            config_full_t{no} = zeros(1, n_top_gap);    % change if other configurations are allowed
            
            for nc = 1 : n_carrier
                for ntg = 1 : n_top_gap
                    new_prod_j = full_prod_t{no}{nc, ntg};
                    new_prod_j.mean_u = ...
                        new_prod_j.mean_u + shocksmln_demand(length(ind_t)+1, :);
                    new_prod_j.mean_mc = ...
                        new_prod_j.mean_mc + shocksmln_mc(length(ind_t)+1, :);
                    
                    ind_fc_nc_ntg = prod_id_add{t, no}==new_prod_j.prod_id;
                    if nnz(ind_fc_nc_ntg)>1
                        error('id mismatch');
                    elseif nnz(ind_fc_nc_ntg)==0
                        new_prod_j.fc = [];
                    else                        
                        new_prod_j.fc = fc_sim_potential{t, no}(ind_fc_nc_ntg, :);
                    end
                    
                    
                    full_prod_t{no}{nc, ntg} = new_prod_j;
                end
            end
        end
    end
end







