function [p,w,q, share, carrier_profit, oem_profit, cons_surplus, cons_surplus_no_error, expmu, prod_profit] = equi_pwq(p0, w0,...
    q0, meanutility, ind_endogenous, carrier_ind, oem_ind, ...
    x_rand, sim_pcoeff, sim_qcoeff, sim_rand, mc_param_q,...
    mc_mean, setup)
% purpose: depending on "mode", compute either the oem pricing eqm, or the carrier pricing eqm
% inputs:
%   p0, w0, q0: either starting point (if it is endogenous) or the given wholesale price (w0), quality (q0) if it is exogenous
%   meanutility: part of the meanutility that is independent of quality and price

% check the number of simulation draws
n_smln = max([size(sim_pcoeff, 2), size(sim_qcoeff, 2)]);
n_prod_t = size(p0, 1);

if (isempty(x_rand)&&~isempty(sim_rand)) || (~isempty(x_rand)&&isempty(sim_rand))
    error('x_rand missing or random draws missing');
end

prod_profit = [];
switch setup.mode
    case 1
        % sequential models
        q = q0;
        q_in_cost = q;
        
        % define mc_handset, which does not include quantity if mc depends on quantity
        mc_handset = exp(q_in_cost/setup.q_scale_in_cost)*mc_param_q+mc_mean;
       
        exp_u_wo_price = bsxfun(@plus, q*sim_qcoeff, meanutility);
        
        exp_u_wo_price = exp(exp_u_wo_price);
        [p, w, share, mc_handset, carrier_profit, oem_variableprofit] = ...
            equi_pw0(p0, w0, exp_u_wo_price, mc_handset, ind_endogenous, ...
            carrier_ind, oem_ind, sim_pcoeff, setup);
        
        oem_profit = oem_variableprofit;
        
        prod_profit = (p-mc_handset).*share;        
    case 2
        % direct_oem, direct_carrier or oem_carrier_collusion
        
        q = q0;
        q_in_cost = q;
        
        mc_handset = exp(q_in_cost/setup.q_scale_in_cost)*mc_param_q+mc_mean;
        
        exp_u_wo_price = bsxfun(@plus, q*sim_qcoeff, meanutility);
        
        exp_u_wo_price = exp(exp_u_wo_price);
        if isequal(setup.pricing_model, 'direct_oem')
            [p, share] = equi_p0(p0, mc_handset, exp_u_wo_price, ind_endogenous,...
                oem_ind, sim_pcoeff, setup);
        elseif isequal(setup.pricing_model, 'direct_carrier') 
            [p, share] = equi_p0(p0, mc_handset, exp_u_wo_price, ind_endogenous,...
                carrier_ind, sim_pcoeff, setup);
        elseif isequal(setup.pricing_model, 'oem_carrier_collusion')
            collusionweightmatrix = zeros(n_prod_t, n_prod_t);
            for no = 1 : size(oem_ind,2)
                Jot = oem_ind(:, no);
                for nc = 1 : size(carrier_ind,2);
                    Jct = carrier_ind(:, nc);
                    collusionweightmatrix(Jot&Jct, Jot&Jct) = 1;
                    collusionweightmatrix(Jot&Jct, Jot&~Jct) = setup.collusion_para_oem * setup.collusion_para_oem_share_of_profit; 
                    collusionweightmatrix(Jot&Jct, ~Jot&Jct) = setup.collusion_para_carrier * (1-setup.collusion_para_oem_share_of_profit);
                end
            end
            setup.collusionweightmatrix = collusionweightmatrix;
            [p, share] = equi_p0(p0, mc_handset, exp_u_wo_price, ind_endogenous,...
                carrier_ind, sim_pcoeff, setup);
        end
        
        prod_profit = (p-mc_handset).*share;
        
        if isequal(setup.pricing_model, 'direct_oem')
            carrier_profit = zeros(size(carrier_ind, 2), 1);
        
            oem_variableprofit = zeros(size(oem_ind,2), 1);
            for no = 1 : size(oem_ind,2)
                if any(oem_ind(:,no))
                    oem_variableprofit(no) = sum(prod_profit(oem_ind(:, no)));
                end
            end
        elseif isequal(setup.pricing_model, 'direct_carrier')
            oem_variableprofit = zeros(size(oem_ind,2), 1);
            
            carrier_profit = zeros(size(carrier_ind, 2), 1);
            for nc = 1 : size(carrier_ind,2)
                if any(carrier_ind(:,nc))
                    carrier_profit(nc) = sum(prod_profit(carrier_ind(:, nc)));
                end
            end
        elseif isequal(setup.pricing_model, 'oem_carrier_collusion')
            oem_variableprofit = zeros(size(oem_ind,2), 1);
            for no = 1 : size(oem_ind,2)
                if any(oem_ind(:,no))
                    oem_variableprofit(no) = sum(prod_profit(oem_ind(:, no)));
                end
            end
            oem_variableprofit = setup.collusion_para_oem_share_of_profit * oem_variableprofit;
            
            carrier_profit = zeros(size(carrier_ind, 2), 1);
            for nc = 1 : size(carrier_ind,2)
                if any(carrier_ind(:,nc))
                    carrier_profit(nc) = sum(prod_profit(carrier_ind(:, nc)));
                end
            end
            carrier_profit = (1-setup.collusion_para_oem_share_of_profit) * carrier_profit;
            
        end
        
        
        
        oem_profit = oem_variableprofit;
        
        w = nan(size(p));
end

if nargout > 6
    if ~isempty(x_rand)
        exp_u_wo_price = bsxfun(@plus, q*sim_qcoeff+x_rand*sim_rand, meanutility);
    else
        exp_u_wo_price = bsxfun(@plus, q*sim_qcoeff, meanutility);
    end
    expmu = bsxfun(@plus, exp_u_wo_price, p*sim_pcoeff);
    cons_surplus_no_error = mean(max([expmu; zeros(1,n_smln)], [], 1)./(-sim_pcoeff), 2);
    expmu = exp(expmu);
    cons_surplus = mean(log(sum(expmu, 1) + 1)./(-sim_pcoeff), 2);
    
    if any(isnan(cons_surplus));
        save('ws_nan_in_cs.mat');
        error('stop the code');
    end
end

