function [f, meanutility, g_obs, para_linear, prob_i, mc, markup_oem, ...
    sim_pcoeff, sim_qcoeff, markup_carrier, ...
    demand_resid, x_det, sim_rand] = ...
    gmmobj_BLP_smartphone(para_nonlinear,...
    share, x_rand, x_det, ind_mkt_start,ind_mkt_end,...
    randomdraw, IV, W, setup, n_oem, n_carrier, n_mkt, ...
    carrier_ind, oem_ind, meanutility00, para_linear00)

mc = [];
markup_oem = [];
markup_carrier = [];
sim_pcoeff = [];
sim_qcoeff = [];


%% get parameters
[para_sigma, para_quality_coeff] = ...
    paravec2para_smartphone(para_nonlinear, setup, x_rand);


%% compute expmu and, for some models, define quality and x_det
cov_chol = diag(para_sigma);
randomdraw = cov_chol'*randomdraw;

para_quality_coeff = [1; para_quality_coeff];
ind1 = setup.dim_quality_in_x_det;
quality = x_det(:, ind1)*para_quality_coeff; 

ind2 = setdiff((1:size(x_det,2)), ind1);    
x_det = [quality, x_det(:, ind2)];% NOTE: IT IS IMPORTANT THAT QUALITY IS THE FIRST COLUMN B/C HOW sim_qcoeff is defined later

x_rand = [quality, x_rand]; % NOTE: IT IS IMPORTANT THAT QUALITY IS THE FIRST COLUMN B/C HOW sim_qcoeff is defined later

expmu = exp(x_rand * randomdraw); % exponentiated, simulated deviations from mean utilities

%% invert the share
if isempty(meanutility00) % need to do inversion
    meanutility = invertshares(share,expmu,ind_mkt_start,ind_mkt_end,setup);
else
    meanutility = meanutility00;
end
if nargout >= 5
    [~, prob_i] = ind_shnorm(exp(meanutility),expmu,ind_mkt_start,ind_mkt_end,setup.mktid);
end

%% estimation
dep = meanutility;

% linear parameters can be estimated by using f.o.c wrt the gmm objective function
if isempty(para_linear00) % need to compute para_linear
    para_linear = inv(x_det'*IV*W*IV'*x_det)*(x_det'*IV*W*IV'*dep);
else
    para_linear = para_linear00;
end

demand_resid = dep - x_det*para_linear;

% obtain moment conditions
g = IV'*demand_resid; 
f = g'*W*g;

if (isnan(f) || isinf(f))
    save('nan_or_inf.mat');
    f = 1e20;
end

% for computing std error
if nargout > 1
    n_iv = size(IV, 2);
    g_obs = repmat(demand_resid, [1 n_iv]).*IV;
end

para_price = para_linear(end-1);   
fprintf(setup.pfid, 'gmmobj = %1.8e, para_quality = %1.8e, para_price = %1.8e', f, para_linear(1), para_price); 
fprintf(setup.pfid, 'para_sigma = ['); fprintf(setup.pfid, ' %1.8e', para_sigma); fprintf(setup.pfid, ']''; \n');
fprintf(setup.pfid, '\n');

fprintf(setup.pfid, 'para_linear ='); fprintf(setup.pfid, ' %1.2e', para_linear); fprintf(setup.pfid, '\n');

%% compute markup
if nargout >= 6
    if setup.invertcost
        sim_pcoeff = para_linear(end-1);
        
        sim_qcoeff = para_linear(1) + randomdraw(1, :); % randomdraw is already multipled by sigma
        
        if size(randomdraw, 1)>1
            sim_rand = randomdraw(2:end, :);
        else
            sim_rand = [];
        end
        
        [markup_oem,negativemarkup_carrier] = invertcost(share,prob_i,sim_pcoeff,[],ind_mkt_end,ind_mkt_start,...
            carrier_ind,oem_ind,setup);
        markup_carrier = -negativemarkup_carrier;
        
        if isequal(setup.pricing_model, 'direct_oem')
            mc = setup.price - markup_oem;
        elseif isequal(setup.pricing_model, 'direct_carrier')
            mc = setup.price + negativemarkup_carrier;
        elseif ismember(setup.pricing_model, {'sequential'; 'apple_att_collusion_during_exclusivecontract'; 'oem_carrier_collusion'})
            mc = negativemarkup_carrier + setup.price - markup_oem;
        else
            error('unknown pricing model')
        end
    end

end

%% SUBFUNCTION
function meanutility = invertshares(share, expmu,ind_mkt_start,ind_mkt_end,setup)
%% invertshares
iter_count = 0; % count the number of contraction mappings

meanutility = setup.meanval_logit; 
logshare = log(share);
while iter_count < 10000
    meanutility1 = meanutility + (logshare-...
        log(ind_shnorm(exp(meanutility), expmu,ind_mkt_start,ind_mkt_end,setup.mktid)));
    t = abs(meanutility1 - meanutility);
    if max(t) <= setup.tol_inner; break; end;
    meanutility = meanutility1;
    iter_count = iter_count + 1;
end

if iter_count >= 9999
    error('BLP inversion does not converge. The iteration stops b/c iter_count >= 2500'); 
end;


function [meanprob, prob_i, exp_u] = ind_shnorm(expmeanval,expmu,ind_mkt_start,ind_mkt_end,mktid)
%% PURPOSE: computes the "individual" probabilities of choosing each brand.

n_mkt = length(ind_mkt_start);

exp_u = repmat(expmeanval, [1 size(expmu, 2)]).*expmu;  % exponentiated utility function

denom_exp_u = nan(n_mkt, size(expmu,2));
for t = 1 : n_mkt
    ind = ind_mkt_start(t):ind_mkt_end(t);
    denom_exp_u(t, :) = sum(exp_u(ind, :), 1);    
end
prob_i = exp_u./(denom_exp_u(mktid,:) + 1);
prob_i(isinf(expmu)) = 1;    

meanprob = mean(prob_i, 2);


