*****This do-file creates moving averages of economic outcomes for daycare project

do "D:\Data\workdata\704665\daycare\dofiles\first.do"

global VARI "wage_inc total_inc"
************************************
/*Make variable list*/

*/**rename key variables in outcome data
forval i=1980/2012 {
use "$work\Doutcome`i'.dta", clear

*Rename key variables
ren ERHVERVSINDK_GL wage_inc

ren perindkialt total_inc

keep pnr year wage_inc total_inc

save "$work\Doutcome`i'.dta", replace
}
******************
**** create separate data sets for different cohorts and then append
use "$work\pop_daycare_popmunic_yrapproval.dta", clear 
ren year exp_year

forval i=1930/1960 {
preserve
keep if fodyear==`i'

foreach var in $VARI {
forval k = 29/61 {
gen age`k'_`var' = .
}
}


gen cpi_index = .
gen cpi2012 = 282.5

save "$work\pop_daycare_exposure_econvars.dta", replace

forval j=1980/2012 {
use "$work\pop_daycare_exposure_econvars.dta", clear
merge 1:1 pnr using "$work\Doutcome`j'.dta", keep(match)


drop _merge
gen age = .
cap drop year
gen year = `j'

replace cpi_index = 100.0 if year == 1980
replace cpi_index = 111.8 if year == 1981
replace cpi_index = 123.1 if year == 1982
replace cpi_index = 131.6 if year == 1983
replace cpi_index = 139.9 if year == 1984
replace cpi_index = 146.4 if year == 1985
replace cpi_index = 151.8 if year == 1986
replace cpi_index = 157.9 if year == 1987
replace cpi_index = 165.0 if year == 1988
replace cpi_index = 172.9 if year == 1989
replace cpi_index = 177.5 if year == 1990
replace cpi_index = 181.7 if year == 1991
replace cpi_index = 185.6 if year == 1992
replace cpi_index = 187.9 if year == 1993
replace cpi_index = 191.6 if year == 1994
replace cpi_index = 195.6 if year == 1995
replace cpi_index = 199.7 if year == 1996
replace cpi_index = 204.2 if year == 1997
replace cpi_index = 207.9 if year == 1998
replace cpi_index = 213.1 if year == 1999
replace cpi_index = 219.3 if year == 2000
replace cpi_index = 224.5 if year == 2001
replace cpi_index = 229.9 if year == 2002
replace cpi_index = 234.7 if year == 2003
replace cpi_index = 237.4 if year == 2004
replace cpi_index = 241.7 if year == 2005
replace cpi_index = 246.3 if year == 2006
replace cpi_index = 250.5 if year == 2007
replace cpi_index = 259.9 if year == 2008
replace cpi_index = 262.4 if year == 2009
replace cpi_index = 268.5 if year == 2010
replace cpi_index = 275.9 if year == 2011
replace cpi_index = 282.5 if year == 2012


*convert to real terms 2012 terms: Var2012 = Var_year * CPI_2012/ CPI_year
foreach var in $VARI {
replace `var' = `var'*(282.5/cpi_index)
}

replace age = `j'-`i'
foreach var in $VARI {
forval k = 29/61 {
replace age`k'_`var' = `var' if age==`k'
}
}
drop age year

keep pnr age*

save "$work\daycare_econout`i'`j'.dta", replace
}

use "$work\daycare_econout`i'1980.dta",clear
forval j=1981/2012 {
append using "$work\daycare_econout`i'`j'.dta"
}
compress
save "$work\daycare_econout`i'.dta",replace

sort pnr
foreach var of varlist age29_wage_inc - age61_total_inc{
by pnr: egen `var'max=max(`var')
drop `var'
rename `var'max `var'
}
sort pnr
by pnr: keep if _n==1

save "$work\daycare_econout`i'.dta",replace

restore
}


use "$work\daycare_econout1930.dta", clear
forval i=1931/1960 {
append using "$work\daycare_econout`i'.dta"
}
keep pnr age*

save "$work\daycare_econout_1.dta",replace
***********************/

use "$work\daycare_econout_1.dta", clear

foreach var in $VARI {

*takes the negative and very large values (trims data)
forval k = 29/61 {
sum age`k'_`var', d
replace age`k'_`var'=. if age`k'_`var'<`r(p1)'
replace age`k'_`var'=. if age`k'_`var'>`r(p99)'
}

gen age2931_`var' = .
gen age3436_`var' = .
gen age3941_`var' = .
gen age4446_`var' = .
gen age4951_`var' = .
gen age5456_`var' = .
gen age5961_`var' = .

replace age2931_`var' = (age29_`var' + age30_`var' + age31_`var')/3 if age29_`var'!=. & age30_`var'!=. & age31_`var'!=.
replace age3436_`var' = (age34_`var' + age35_`var' + age36_`var')/3 if age34_`var'!=. & age35_`var'!=. & age36_`var'!=.
replace age3941_`var' = (age39_`var' + age40_`var' + age41_`var')/3 if age39_`var'!=. & age40_`var'!=. & age41_`var'!=.
replace age4446_`var' = (age44_`var' + age45_`var' + age46_`var')/3 if age44_`var'!=. & age45_`var'!=. & age46_`var'!=.
replace age4951_`var' = (age49_`var' + age50_`var' + age51_`var')/3 if age49_`var'!=. & age50_`var'!=. & age51_`var'!=.
replace age5456_`var' = (age54_`var' + age55_`var' + age56_`var')/3 if age54_`var'!=. & age55_`var'!=. & age56_`var'!=.
replace age5961_`var' = (age59_`var' + age60_`var' + age61_`var')/3 if age59_`var'!=. & age60_`var'!=. & age61_`var'!=.

*mean over ages 30-60 (ignoring missings at ages not observed in our data)
egen age3060_mean_`var' = rowmean(age30_`var'-age60_`var')

forval k=30/60 {
gen pdv`k'_`var' = age`k'_`var'/((1.03)^(`k'-30))
}
egen age3060_PDV_`var' = rowtotal(pdv30_`var'-pdv60_`var')
}

drop pdv*

save "$work\earnings_cb.dta",replace

keep pnr age2931_wage_inc- age3060_PDV_total_inc
compress
save "$work\daycare_econout.dta",replace



* erase
forval i=1930/1960{
forval j=1981/2012 {
erase "$work\daycare_econout`i'`j'.dta"
}
}
