* ONLY MOMS (FOR INTERGENERATIONAL COMPARISONS)

do "D:\Data\workdata\704665\daycare\dofiles\first.do"

use "$work\analysis_daycare_onlymoms_everopen.dta", clear

** merge to kids data for computing intergenerational coef
merge 1:1 muni year using "$work\tomerge_tomoms.dta"
drop _merge
merge 1:1 muni year using "$work\analysis_daycare_muni_ever_yrapproval.dta"

keep if _merge==3
drop _merge

label var operating "Any Approved Preschool at Age 3"


*mainouts
foreach vars of global mainout  {

	 areg `vars' operating  $style1 , abs(muni) cl(muni)
	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1
	estadd scalar dv=`r(mean)'
	
	areg `vars' operating  $style2 , abs(muni) cl(muni)
			
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1
	estadd scalar dv=`r(mean)'

}

/*Creates the table  */
file open myfile using "$results\mainout_moms.tex", write replace
file write myfile "\begin{tabular}{p{2in} ccc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	& (3) 			 		\\" _n 
file close myfile
foreach vars of global mainout  {
	estout `vars'* using "$results\mainout_moms.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Mean of dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\mainout_moms.tex", write append
do $dofiles\tabbottom.do

estimates clear
