*************************************************************
*Assigns all the libraries to be used in analytical files.
*defines globals for analyses/tables
*************************************************************
clear all
capture log close
version 13
set more off, perm

* directories
global download "D:\Data\workdata\704665\daycare\downloads"
global dofiles "D:\Data\workdata\704665\daycare\dofiles\munic_analysis"
global graphs "D:\Data\workdata\704665\daycare\graphs"
global raw "D:\Data\workdata\704665\rawdata"
global map "D:\Data\workdata\704665\mapdata"
global work "D:\Data\workdata\704665\daycare\work"
global format "D:\Data\Formater\Gamle formater"
global results "D:\Data\workdata\704665\daycare\results"
global external "D:\Data\workdata\704665\External data_raw"


*controls
#delimit ;
global munichar  socialdemo1929 agrarianlib1929 radicallib1929 conservatives1929
	 urban1930 pop1930 agripop1930 industrypop1930 femalepop1930 incometaxpercent1930 logtaxableincome1930 propertytaxpercent1930;
	
*#delimit cr
#delimit ;
global contrvars  ipol_socialdemo ipol_radicallib ipol_agrarianlib ipol_conservatives ipol_pop ipol_urban ipol_femalepop 
ipol_industrypop ipol_agripop ipol_incometaxpercent ipol_logtaxableincome ipol_propertytaxpercent
 ;
#delimit cr


* style for regs - collapsed data and indiv data
global style1 "i.year $contrvars [aweight=N]"
global style2 "i.year  $contrvars i.county#c.year [aweight=N]"

global styleind1 "i.year $contrvars "
global styleind2 "i.year  $contrvars i.county#c.year "


* outcomes
global hc index_hc surv65
global mainout index_hc year50 morethanbasic50 ln_age3060_mean_wage_inc surv65
global otherinc age3060_mean_wage_inc ln_age3060_PDV_wage_inc ln_age3060_mean_total_inc ln_age4951_wage_inc any_age4951_wage_inc 
global surv surv55 surv60 surv65
global nights nights45 nights55 nights65
global diag60  cardio60 heart60 diab60 cancer60
global diagnights60 nights55 cardio60 heart60 diab60 cancer60
global kidedu25 yrsschool25_kid morethanbasic25_kid gymnasium25_kid 
global fertility nokids numkids ageat_firstbirth dad_evermissing
global predoutkid pryrsschool25_kid prmorethanbasic25_kid prgymnasium25_kid 


* for output tables
global title_index_hc "Human Capital Index" 
global title_year50 "Yrs. of Schooling" 
global title_morethanbasic50 "More than Compulsory Educ." 
global title_ln_age3060_mean_wage_inc "Log Avg Age 30-60 Wage Inc." 
global title_death65  "Death by 65"
global title_surv65  "Survival beyond Age 65"
global title_surv55  "Survival beyond Age 55"
global title_surv60  "Survival beyond Age 60"

global title_age3060_mean_wage_inc "Avg Age 30-60 Wage Inc"
global title_ln_age3060_PDV_wage_inc "Log Age 30-60 PDV Wage Inc"
global title_ln_age3060_mean_total_inc "Log Avg Age 30-60 Tot Inc"
global title_ln_age4951_wage_inc "Log Avg Age 49-51 Wage Inc"
global title_any_age4951_wage_inc "Any Wage Inc., Age 49-51"

global title_nights45 "Hosp: Nights: Age 45-54" 
global title_nights55 "Hosp: Nights: Age 55-64" 
global title_nights65 "Hosp: Nights: Age 65-74" 

global title_cardio60 "Diagnosed Cardio" 
global title_heart60 "Diagnosed Heart" 
global title_diab60 "Diagnosed Diabetes" 
global title_cancer60 "Diagnosed Cancer"
global title_nights55 "Hosp. Nights: Age 55-64"


global title_yrsschool25_kid "Child's Years of Schooling"
global title_morethanbasic25_kid "Child Has More than Compulsory Education"
global title_gymnasium25_kid "Child Has Completed Gymnasium"


global title_nights25 "Hosp. nights, age 25"
global title_nights30 "Hosp. nights, age 30"
global title_ever25 "Ever hosp., age 25"
global title_ever30 "Ever hosp., age 30"


cd "$work"

