log using "/home/projects/sehs/replication/logs/footnote16.log", replace

* Program:	FOOTNOTE16.DO
* Date:		20 jan 2018
* Written by:	LB
*
* Notes:	Explore the differences between the rule-based admissions and where students are enrolling
*
* Input Files:	
*	/home/projects/sehs/replication/data/analytic_replication.dta

tempfile temp1 temp2

use "/home/projects/sehs/replication/data/analytic_replication.dta", clear

drop if dsped8==1
drop if completeapp==0
keep if sidtype=="both" | sidtype=="only9"
*dropping people missing tier
drop if inlist(tier, 0, .)

*Create new "offer" variables given the rule offer.

gen brooks_offer=offerrule=="Brooks"
gen jones_offer=offerrule=="Jones"
gen king_offer=offerrule=="King"
gen lane_offer=offerrule=="Lane"
gen lindblom_offer=offerrule=="Lindblom"
gen northside_offer=offerrule=="Northside"
gen payton_offer=offerrule=="Payton"
gen southshore_offer=offerrule=="South Shore"
gen westinghouse_offer=offerrule=="Westinghouse"
gen young_offer=offerrule=="Young"

gen brooks_enroll=schlname9=="BROOKS COLL PREP"
gen jones_enroll=schlname9=="JONES COLL PREP HIGH"
gen king_enroll=schlname9=="KING HIGH"
gen lane_enroll=schlname9=="LANE TECH HIGH"
gen lindblom_enroll=schlname9=="LINDBLOM MATH/SCI"
gen northside_enroll=schlname9=="NORTHSIDE COLL PREP"
gen payton_enroll=schlname9=="PAYTON COLL PREP HS"
gen southshore_enroll=schlname9=="SOUTH SHORE INTL" & cohort9==2013
gen westing_enroll=schlname9=="WESTINGHOUSE HS"
gen young_enroll=schlname9=="YOUNG MAGNET HIGH"

label variable brooks_cut_centered "Brooks"
label variable jones_cut_centered "Jones"
label variable king_cut_centered "King"
label variable lane_cut_centered "Lane Tech"
label variable lindblom_cut_centered "Lindblom"
label variable northside_cut_centered "Northside"
label variable payton_cut_centered "Payton"
label variable southshore_cut_centered "Southshore"
label variable westing_cut_centered "Westinghouse"
label variable young_cut_centered "Young"

* Identify students who were enrolled in a selective in grade 8
gen selective8=0
replace selective8=1 if inlist(schid8,609720,609726,609751,610391,609749,609680,609755,609678,609693)

replace offerrule="none" if offerrule==""
tab offergroup cohort9 if selective==1 & offerrule=="none", col row miss

preserve
keep if offergroup!="PD"
tab schlname9 cohort9 if selective==1 & offerrule=="none", col miss 
tab selective8 cohort9 if selective==1 & offerrule=="none", col miss 
tab schlname8 cohort9 if selective==1 & offerrule=="none", col miss 
restore
by cohort9, sort: tab offer offerrule, col miss

